//
//  LocalizeMeViewController.m
//  LocalizeMe
//
//  Created by Robert Górczyński on 11-08-08.
//

#import "LocalizeMeViewController.h"

@implementation LocalizeMeViewController
@synthesize localeLabel; 
@synthesize label1; 
@synthesize label2; 
@synthesize label3; 
@synthesize label4; 
@synthesize label5; 

- (void)viewDidLoad { 
    NSLocale *locale = [NSLocale currentLocale]; 
    NSString *displayNameString = [locale 
								   displayNameForKey:NSLocaleIdentifier 
								   value:[locale localeIdentifier]]; 
    localeLabel.text = displayNameString; 
	
    label1.text = NSLocalizedString(@"One", @"The number 1"); 
    label2.text = NSLocalizedString(@"Two", @"The number 2"); 
    label3.text = NSLocalizedString(@"Three", @"The number 3"); 
    label4.text = NSLocalizedString(@"Four", @"The number 4"); 
    label5.text = NSLocalizedString(@"Five", @"The number 5"); 
    [super viewDidLoad]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.localeLabel = nil; 
    self.label1 = nil; 
    self.label2 = nil; 
    self.label3 = nil; 
    self.label4 = nil; 
    self.label5 = nil; 
    [super viewDidUnload]; 	
}


- (void)dealloc {
    [localeLabel release]; 
    [label1 release];
    [label2 release]; 
    [label3 release]; 
    [label4 release]; 
    [label5 release]; 	
    [super dealloc];
}

@end
